uniform vec3		fogColor;
uniform float 		extintion;

// costanti passate allo shader
uniform vec3  SUN; 	// = colore del sole
uniform vec3  cBr; 	// = RayLeigh
uniform vec3  cBm; 	// = Mie	
uniform	vec3  C0; 	// = cBr+cBm;	
uniform vec3  C1; 	// = 1.0/(cBr+cBm);

uniform float C4;	// = (1-g)^2
uniform float C5;	// = 1+g^2
uniform float C6;	// = 2*g
uniform float C7;	// = 3/2

uniform vec3	zenithColor;
uniform vec3	horizonColor;
uniform float	waterHeight;

vec3	vPos;
vec3	cnormal;
vec3 	cC0;
vec3 	baseColor;

uniform vec3  campos;
uniform float cHeightFallof;

// vertex attributes
attribute vec3 			s2_vertex;
attribute vec4			s2_texcoords; 
varying vec3			viewdir;
varying float 			h;

float cVolFogHeightDensityAtViewer=exp( cHeightFallof * -campos.y);

float ComputeVolumetricFog( vec3 cameraToWorldPos )
{
	float fogInt = length( cameraToWorldPos )*cVolFogHeightDensityAtViewer;
	if( abs(cameraToWorldPos.y ) > 0.01)
	{
		float t = cHeightFallof * cameraToWorldPos.y;
		fogInt *= ( 1.0-exp( -t ) ) / t;
	}
	return fogInt;
}

void main()
{
	vec4 vertex=vec4(s2_vertex,1.0);//*vec4(1.0,0.5,1.0,1.0);
	gl_Position = gl_ModelViewProjectionMatrix*vertex;
	h=vertex.y;
	viewdir=normalize(vertex.xyz);
}